# $Id: install.py 893 2014-03-13 04:24:14Z mwall $
# installer for Xively
# Copyright 2014 Matthew Wall

from setup import ExtensionInstaller

def loader():
    return XivelyInstaller()

class XivelyInstaller(ExtensionInstaller):
    def __init__(self):
        super(XivelyInstaller, self).__init__(
            version="0.2",
            name='xively',
            description='Upload weather data to Xively.',
            author="Matthew Wall",
            author_email="mwall@users.sourceforge.net",
            restful_services='user.xively.Xively',
            config={
                'StdRESTful': {
                    'Xively': {
                        'token': 'INSERT_TOKEN_HERE',
                        'feed': 'INSERT_FEED_HERE',
                        'station_name': 'INSERT_STATION_NAME_HERE'}}},
            files=[('bin/user', ['bin/user/xively.py'])]
            )
