# $Id: install.py 1005 2014-08-16 18:39:45Z mwall $
# installer for WeatherLink driver
# Copyright 2014 Matthew Wall

from setup import ExtensionInstaller

def loader():
    return WeatherLinkInstaller()

class WeatherLinkInstaller(ExtensionInstaller):
    def __init__(self):
        super(WeatherLinkInstaller, self).__init__(
            version="0.2",
            name='wlink',
            description='driver that collects data from weatherlink.com',
            author="Matthew Wall",
            author_email="mwall@users.sourceforge.net",
            config={
                'Station', {
                    'station_type': 'WeatherLink'},
                'OWFS', {
                    'driver': 'user.wlink',
                    'username': 'USERNAME',
                    'password': 'PASSWORD'}},
            files=[('bin/user', ['bin/user/wlink.py'])]
            )
