# $Id: install.py 1036 2014-09-21 15:23:03Z mwall $
# installer for Twitter
# Copyright 2014 Matthew Wall

from setup import ExtensionInstaller

def loader():
    return TwitterInstaller()

class TwitterInstaller(ExtensionInstaller):
    def __init__(self):
        super(TwitterInstaller, self).__init__(
            version="0.1",
            name='twitter',
            description='tweet weather data',
            author="Matthew Wall",
            author_email="mwall@users.sourceforge.net",
            restful_services='user.twitter.Twitter',
            config={
                'StdRESTful': {
                    'Twitter': {
                        'station': 'STATION_IDENTIFIER',
                        'app_key': 'APP_KEY',
                        'app_secret': 'APP_SECRET',
                        'oauth_token': 'OAUTH_TOKEN',
                        'oauth_token_secret': 'OAUTH_TOKEN_SECRET'}}},
            files=[('bin/user', ['bin/user/twitter.py'])]
            )
