# $Id: install.py 875 2014-03-02 16:05:46Z mwall $
# installer for pmon
# Copyright 2014 Matthew Wall

from setup import ExtensionInstaller

def loader():
    return ProcessMonitorInstaller()

class ProcessMonitorInstaller(ExtensionInstaller):
    def __init__(self):
        super(ProcessMonitorInstaller, self).__init__(
            version="0.1",
            name='pmon',
            description='Collect and display process memory usage.',
            author="Matthew Wall",
            author_email="mwall@users.sourceforge.net",
            process_services='user.pmon.ProcessMonitor',
            config={
                'ProcessMonitor': {
                    'database': 'pmon_sqlite',
                    'max_age': '2592000'},
                'Databases': {
                    'pmon_sqlite': {
                        'database': 'pmon.sdb',
                        'driver': 'weedb.sqlite'}},
                'StdReport': {
                    'pmon': {
                        'skin':'pmon',
                        'HTML_ROOT':'pmon' }}},
            files=[('bin/user',
                    ['bin/user/pmon.py']),
                   ('skins/pmon',
                    ['skins/pmon/skin.conf',
                     'skins/pmon/index.html.tmpl']),
                   ]
            )
