# $Id: install.py 1096 2014-11-12 05:15:56Z mwall $
# installer for OpenWeatherMap
# Copyright 2014 Matthew Wall

from setup import ExtensionInstaller

def loader():
    return OWMInstaller()

class OWMInstaller(ExtensionInstaller):
    def __init__(self):
        super(OWMInstaller, self).__init__(
            version="0.3",
            name='owm',
            description='Upload weather data to OpenWeatherMap.',
            author="Matthew Wall",
            author_email="mwall@users.sourceforge.net",
            restful_services='user.owm.OpenWeatherMap',
            config={
                'StdRESTful': {
                    'OpenWeatherMap': {
                        'username': 'INSERT_USERNAME_HERE',
                        'password': 'INSERT_PASSWORD_HERE',
                        'station_name': 'INSERT_STATION_NAME_HERE'}}},
            files=[('bin/user', ['bin/user/owm.py'])]
            )
