# $Id: install.py 832 2014-02-01 19:27:20Z mwall $
# installer for owfss
# Copyright 2014 Matthew Wall

from setup import ExtensionInstaller

def loader():
    return OWFSServiceInstaller()

class OWFSServiceInstaller(ExtensionInstaller):
    def __init__(self):
        super(OWFSServiceInstaller, self).__init__(
            version="0.5",
            name='owfss',
            description='Collect data from one-wire sensors using owfs',
            author="Matthew Wall",
            author_email="mwall@users.sourceforge.net",
            archive_services='user.owfss.OWFSService',
            config={
                'OWFSService': {
                    'interface': 'u',
                    'sensor_map': {},
                    'data_type': {}}},
            files=[('bin/user', ['bin/user/owfss.py'])]
            )
