# $Id: install.py 978 2014-08-09 02:37:11Z mwall $
# installer for OWFS
# Copyright 2014 Matthew Wall

from setup import ExtensionInstaller

def loader():
    return OWFSInstaller()

class OWFSInstaller(ExtensionInstaller):
    def __init__(self):
        super(OWFSInstaller, self).__init__(
            version="0.6",
            name='owfs',
            description='driver for one-wire devices connected via owfs',
            author="Matthew Wall",
            author_email="mwall@users.sourceforge.net",
            config={
                'Station', {
                    'station_type': 'OWFS'},
                'OWFS', {
                    'interface': 'u',
                    'driver': 'user.owfs',
                    'sensor_map': {},
                    'sensor_type': {}}},
            files=[('bin/user', ['bin/user/owfs.py'])]
            )
