# $Id: install.py 1595 2016-11-27 18:01:54Z mwall $
# installer for OWFS
# Copyright 2014 Matthew Wall

from setup import ExtensionInstaller

def loader():
    return OWFSInstaller()

class OWFSInstaller(ExtensionInstaller):
    def __init__(self):
        super(OWFSInstaller, self).__init__(
            version="0.19rc1",
            name='owfs',
            description='driver for one-wire devices connected via owfs',
            author="Matthew Wall",
            author_email="mwall@users.sourceforge.net",
            config={
                'OWFS': {
                    'driver': 'user.owfs',
                    'interface': 'u',
                    'sensor_map': {},
                    'sensor_type': {}}},
            files=[('bin/user', ['bin/user/owfs.py'])]
            )
