# $Id: install.py 1153 2014-12-02 03:03:19Z mwall $
# installer for OWFS
# Copyright 2014 Matthew Wall

from setup import ExtensionInstaller

def loader():
    return OWFSInstaller()

class OWFSInstaller(ExtensionInstaller):
    def __init__(self):
        super(OWFSInstaller, self).__init__(
            version="0.11",
            name='owfs',
            description='driver for one-wire devices connected via owfs',
            author="Matthew Wall",
            author_email="mwall@users.sourceforge.net",
            config={
                'OWFS': {
                    'driver': 'user.owfs',
                    'interface': 'u',
                    'sensor_map': {},
                    'sensor_type': {}}},
            files=[('bin/user', ['bin/user/owfs.py'])]
            )
