## heatmap display for weewx - Copyright 2012-2013 Matthew Wall
## $Id: heatmap_table.inc 1129 2014-11-22 02:45:11Z mwall $
## version = 0.1

#set $month_names = $getVar('Extras.heatmap_table_settings.month_names',
    ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'])
#set $fmt = $getVar('Extras.heatmap_table_settings.format', "%.1f")

#set $s_year = time.localtime($start_ts)[0]
#set $e_year = time.localtime($end_ts)[0]
#set $rows = 1 + $e_year - $s_year
#set $cols = 12
#set $ts = $s_year
#set $idx = 0

<table class='heatmap'>
  <tr>
    <th></th>
#for $m in $month_names
    <th>$m</th>
#end for
  </tr>
#for $r in range($rows)
#set $current_year = $s_year + $r
  <tr>
    <td class='heatmap_year'>$current_year</td>
#for $c in range($cols)
#set $val = '-'
#if $ts >= $start_ts and $idx < len($data)
#set $val = $fmt % $data[$idx]
#set $idx = $idx + 1
#end if
    <td class='heatmap_datum'>
<span style='background: $heatmap.get_color($val, min_value=$min_val, max_value=$max_val)'>$val</span>
    </td>
#set $ts = time.mktime(($s_year+$r,$c+1,0,0,0,0,0,0,0))
#end for
  </tr>
#end for
</table>
