# $Id: install.py 1126 2014-11-21 14:58:27Z mwall $
# installer for the heatmap extension
# Copyright 2014 Matthew Wall

from setup import ExtensionInstaller

def loader():
    return HeatmapInstaller()

class HeatmapInstaller(ExtensionInstaller):
    def __init__(self):
        super(HeatmapInstaller, self).__init__(
            version="0.1",
            name='heatmap',
            description='Display data as a heatmap.',
            author="Matthew Wall",
            author_email="mwall@users.sourceforge.net",
            config={
                'StdReport': {
                    'heatmap': {
                        'skin': 'heatmap',
                        'HTML_ROOT': 'heatmap',
                        'Extras': {
                            'heatmap_table':'INST_SKIN_ROOT/heatmap/heatmap_table.inc'}}}},
            files=[('bin/user',
                    ['bin/user/heatmap.py']),
                   ('skins/heatmap',
                    ['skins/heatmap/skin.conf',
                     'skins/heatmap/heatmap_table.inc',
                     'skins/heatmap/index.html.tmpl']),
                   ]
            )
