# $Id: heatmap.py 1131 2014-11-24 13:52:42Z mwall $
# Copyright 2013 Matthew Wall, all rights reserved
"""Variables for the heatmap extension"""

import calendar
import time

from weewx.cheetahgenerator import SearchList
import weewx.manager

class HeatmapVariables(SearchList):
    
    def __init__(self, generator):
        SearchList.__init__(self, generator)
        self.lo_color = 0
        self.hi_color = 255
        self.lo_value = 0
        self.hi_value = 100

    def get_extension_list(self, timespan, db_lookup):
        return [{'heatmap': self}]

    def get_color(self, value, min_value=0, max_value=100,
                  r_lo=255, r_hi=255, g_lo=255, g_hi=0, b_lo=255, b_hi=0):
        try:
            x = float(value)
            if x < min_value:
                x = min_value
            if x > max_value:
                x = max_value
            y = (x - min_value) / (max_value - min_value)
            r = y * (r_hi - r_lo) + r_lo
            g = y * (g_hi - g_lo) + g_lo
            b = y * (b_hi - b_lo) + b_lo
            s = '#%02x%02x%02x' % (r,g,b)
        except ValueError:
            s = '#ffffff'
        return s

    def get_data(self, obs):
        start_ts = None
        end_ts = None
        min_values = []
        avg_values = []
        max_values = []
        dbm_dict = weewx.manager.get_manager_dict(
            self.generator.config_dict['DataBindings'],
            self.generator.config_dict['Databases'],
            'wx_binding')
        with weewx.manager.open_manager(dbm_dict) as dbm:
            table_name = "%s_day_%s" % (dbm.table_name, obs)
            for row in dbm.genSql("SELECT strftime('%%Y', datetime(dateTime, 'unixepoch', 'localtime')) as Year, strftime('%%m', datetime(dateTime, 'unixepoch', 'localtime')) as Month, MIN(min) FROM %s GROUP BY Year, Month" % table_name):
                min_values.append(row[2])
                if start_ts is None:
                    start_ts = calendar.timegm((int(row[0]),int(row[1]),0,0,0,0,0,0,0))
                end_ts = calendar.timegm((int(row[0]),int(row[1]),28,0,0,0,0,0,0))
            for row in dbm.genSql("SELECT strftime('%%Y', datetime(dateTime, 'unixepoch', 'localtime')) as Year, strftime('%%m', datetime(dateTime, 'unixepoch', 'localtime')) as Month, MAX(max) FROM %s GROUP BY Year, Month" % table_name):
                max_values.append(row[2])
            for row in dbm.genSql("SELECT strftime('%%Y', datetime(dateTime, 'unixepoch', 'localtime')) as Year, strftime('%%m', datetime(dateTime, 'unixepoch', 'localtime')) as Month, SUM(sum) / SUM(count) FROM %s GROUP BY Year, Month" % table_name):
                avg_values.append(row[2])
        min_value = min(min_values)
        max_value = max(max_values)
        return start_ts, end_ts, min_value, max_value, min_values, avg_values, max_values
