# $Id: install.py 1742 2017-09-07 12:09:29Z mwall $
# installer for exfoliation
# Copyright 2014-2017 Matthew Wall

from setup import ExtensionInstaller

def loader():
    return ExfoliationInstaller()

class ExfoliationInstaller(ExtensionInstaller):
    def __init__(self):
        super(ExfoliationInstaller, self).__init__(
            version="0.43",
            name='exfoliation',
            description='A minimalist layout with lots of data.',
            author="Matthew Wall",
            author_email="mwall@users.sourceforge.net",
            config={
                'StdReport': {
                    'exfoliation': {
                        'skin':'exfoliation',
                        'HTML_ROOT':'exfoliation'}}},
            files=[('skins/exfoliation',
                    ['skins/exfoliation/almanac.html.tmpl',
                     'skins/exfoliation/cookies.js',
                     'skins/exfoliation/exfoliation.css',
                     'skins/exfoliation/exfoliation.js',
                     'skins/exfoliation/favicon.ico',
                     'skins/exfoliation/footer.inc',
                     'skins/exfoliation/forecast.html.tmpl',
                     'skins/exfoliation/forecast_iconic.css',
                     'skins/exfoliation/forecast_iconic.inc',
                     'skins/exfoliation/forecast_strip.css',
                     'skins/exfoliation/forecast_strip.inc',
                     'skins/exfoliation/forecast_table.css',
                     'skins/exfoliation/forecast_table.inc',
                     'skins/exfoliation/header.inc',
                     'skins/exfoliation/hilo.inc',
                     'skins/exfoliation/history.html.tmpl',
                     'skins/exfoliation/index.html.tmpl',
                     'skins/exfoliation/links.html.tmpl',
                     'skins/exfoliation/skin.conf',
                     'skins/exfoliation/station.html.tmpl',
                     'skins/exfoliation/weewx_rss.xml.tmpl']),
                   ('skins/exfoliation/NOAA',
                    ['skins/exfoliation/NOAA/NOAA-YYYY-MM.txt.tmpl',
                     'skins/exfoliation/NOAA/NOAA-YYYY.txt.tmpl']),
                   ('skins/exfoliation/font',
                    ['skins/exfoliation/font/Roboto-Bold.ttf',
                     'skins/exfoliation/font/Roboto-Bold.woff',
                     'skins/exfoliation/font/Roboto-Bold.woff2',
                     'skins/exfoliation/font/Roboto-Regular.ttf',
                     'skins/exfoliation/font/Roboto-Regular.woff',
                     'skins/exfoliation/font/Roboto-Regular.woff2']),
                   ('skins/exfoliation/icons',
                    ['skins/exfoliation/icons/AF.png',
                     'skins/exfoliation/icons/B1.png',
                     'skins/exfoliation/icons/B1n.png',
                     'skins/exfoliation/icons/B2.png',
                     'skins/exfoliation/icons/B2n.png',
                     'skins/exfoliation/icons/BD.png',
                     'skins/exfoliation/icons/BK.png',
                     'skins/exfoliation/icons/BKn.png',
                     'skins/exfoliation/icons/BS.png',
                     'skins/exfoliation/icons/CL.png',
                     'skins/exfoliation/icons/CLn.png',
                     'skins/exfoliation/icons/E.png',
                     'skins/exfoliation/icons/F+.png',
                     'skins/exfoliation/icons/F.png',
                     'skins/exfoliation/icons/FW.png',
                     'skins/exfoliation/icons/FWn.png',
                     'skins/exfoliation/icons/H.png',
                     'skins/exfoliation/icons/K.png',
                     'skins/exfoliation/icons/N.png',
                     'skins/exfoliation/icons/NE.png',
                     'skins/exfoliation/icons/NW.png',
                     'skins/exfoliation/icons/OV.png',
                     'skins/exfoliation/icons/OVn.png',
                     'skins/exfoliation/icons/PF+.png',
                     'skins/exfoliation/icons/PF.png',
                     'skins/exfoliation/icons/S.png',
                     'skins/exfoliation/icons/SC.png',
                     'skins/exfoliation/icons/SCn.png',
                     'skins/exfoliation/icons/SE.png',
                     'skins/exfoliation/icons/SW.png',
                     'skins/exfoliation/icons/W.png',
                     'skins/exfoliation/icons/blizzard.png',
                     'skins/exfoliation/icons/drizzle.png',
                     'skins/exfoliation/icons/flag-yellow.png',
                     'skins/exfoliation/icons/flag.png',
                     'skins/exfoliation/icons/flurries.png',
                     'skins/exfoliation/icons/frzngdrzl.png',
                     'skins/exfoliation/icons/moon.png',
                     'skins/exfoliation/icons/moonphase.png',
                     'skins/exfoliation/icons/moonrise.png',
                     'skins/exfoliation/icons/moonriseset.png',
                     'skins/exfoliation/icons/moonset.png',
                     'skins/exfoliation/icons/pop.png',
                     'skins/exfoliation/icons/rain.png',
                     'skins/exfoliation/icons/raindrop.png',
                     'skins/exfoliation/icons/rainshwrs.png',
                     'skins/exfoliation/icons/raintorrent.png',
                     'skins/exfoliation/icons/sleet.png',
                     'skins/exfoliation/icons/snow.png',
                     'skins/exfoliation/icons/snowflake.png',
                     'skins/exfoliation/icons/snowshwrs.png',
                     'skins/exfoliation/icons/sprinkles.png',
                     'skins/exfoliation/icons/sun.png',
                     'skins/exfoliation/icons/sunmoon.png',
                     'skins/exfoliation/icons/sunrise.png',
                     'skins/exfoliation/icons/sunriseset.png',
                     'skins/exfoliation/icons/sunset.png',
                     'skins/exfoliation/icons/tE.png',
                     'skins/exfoliation/icons/tENE.png',
                     'skins/exfoliation/icons/tESE.png',
                     'skins/exfoliation/icons/tN.png',
                     'skins/exfoliation/icons/tNE.png',
                     'skins/exfoliation/icons/tNNE.png',
                     'skins/exfoliation/icons/tNNW.png',
                     'skins/exfoliation/icons/tNW.png',
                     'skins/exfoliation/icons/tS.png',
                     'skins/exfoliation/icons/tSE.png',
                     'skins/exfoliation/icons/tSSE.png',
                     'skins/exfoliation/icons/tSSW.png',
                     'skins/exfoliation/icons/tSW.png',
                     'skins/exfoliation/icons/tW.png',
                     'skins/exfoliation/icons/tWNW.png',
                     'skins/exfoliation/icons/tWSW.png',
                     'skins/exfoliation/icons/thermometer-blue.png',
                     'skins/exfoliation/icons/thermometer-dewpoint.png',
                     'skins/exfoliation/icons/thermometer-red.png',
                     'skins/exfoliation/icons/thermometer.png',
                     'skins/exfoliation/icons/triangle-down.png',
                     'skins/exfoliation/icons/triangle-right.png',
                     'skins/exfoliation/icons/tstms.png',
                     'skins/exfoliation/icons/water.png']),
                   ]
            )
