# $Id: install.py 892 2014-03-13 04:16:32Z mwall $
# installer for EmonCMS
# Copyright 2014 Matthew Wall

from setup import ExtensionInstaller

def loader():
    return EmonCMSInstaller()

class EmonCMSInstaller(ExtensionInstaller):
    def __init__(self):
        super(EmonCMSInstaller, self).__init__(
            version="0.2",
            name='emoncms',
            description='Upload weather data to EmonCMS.',
            author="Matthew Wall",
            author_email="mwall@users.sourceforge.net",
            restful_services='user.emoncms.EmonCMS',
            config={
                'StdRESTful': {
                    'EmonCMS': {
                        'token': 'INSERT_TOKEN_HERE'}}},
            files=[('bin/user', ['bin/user/emoncms.py'])]
            )
