# $Id: install.py 1177 2014-12-08 14:17:22Z mwall $
# installer for cwxn
# Copyright 2014 Matthew Wall

from setup import ExtensionInstaller

def loader():
    return CWXNInstaller()

class CWXNInstaller(ExtensionInstaller):
    def __init__(self):
        super(CWXNInstaller, self).__init__(
            version="0.3",
            name='cwxn',
            description='Emit a Cumulus wxnow.txt for LOOP data.',
            author="Matthew Wall",
            author_email="mwall@users.sourceforge.net",
            process_services='user.cwxn.CumulusWXNow',
            config={
                'CumulusWXNow' : {
                    'filename': '/var/tmp/wxnow.txt'}},
            files=[('bin/user', ['bin/user/cwxn.py'])]
            )
