# $Id: csv.py 1313 2015-05-02 23:29:52Z mwall $
# Copyright 2015 Matthew Wall

import os
import os.path
import time

import weewx
import weewx.engine

class CSV(weewx.engine.StdService):
    def __init__(self, engine, config_dict):
        super(CSV, self).__init__(engine, config_dict)
        d = config_dict.get('CSV', {})
        self.filename = d.get('filename', '/var/tmp/data.csv')
        self.header = d.get('header', True)
        self.append = d.get('append', True)
        self.binding = d.get('binding', 'loop')
        if self.binding == 'loop':
            self.bind(weewx.NEW_LOOP_PACKET, self.handle_new_loop)
        else:
            self.bind(weewx.NEW_ARCHIVE_RECORD, self.handle_new_archive)

    def handle_new_loop(self, event):
        self.write_data(event.packet)

    def handle_new_archive(self, event):
        delta = time.time() - event.record['dateTime']
        if delta > event.record['interval'] * 60:
            return
        self.write_data(event.record)

    def write_data(self, data):
        if self.header and not os.path.exists(self.filename):
            self.write_line(self.sort_keys(data))
        self.write_line(self.sort_data(data))

    def write_line(self, fields):
        flag = "a" if self.append else "w"
        with open(self.filename, flag) as f:
            f.write('%s\n' % ','.join(fields))

    def sort_keys(self, record):
        fields = ['dateTime']
        for k in sorted(record):
            if k != 'dateTime':
                fields.append(k)
        return fields

    def sort_data(self, record):
        fields = [str(record['dateTime'])]
        for k in sorted(record):
            if k != 'dateTime':
                fields.append(str(record[k]))
        return fields
