# $Id: install.py 1029 2014-08-31 12:57:33Z mwall $
# installer for crt
# Copyright 2014 Matthew Wall

from setup import ExtensionInstaller

def loader():
    return CRTInstaller()

class CRTInstaller(ExtensionInstaller):
    def __init__(self):
        super(CRTInstaller, self).__init__(
            version="0.6",
            name='crt',
            description='Emit a Cumulus realtime.txt for LOOP data.',
            author="Matthew Wall",
            author_email="mwall@users.sourceforge.net",
            process_services='user.crt.CumulusRealTime',
            config={
                'CumulusRealTime' : {
                    'filename': '/var/tmp/realtime.txt'}},
            files=[('bin/user', ['bin/user/crt.py'])]
            )
