#!/bin/sh

# this expects the /var partition to have sufficient space

install_prereq() {
    # for encoding to video
    apt-get -q -y install mencoder libav-tools ffmpeg
    # for creating thumbnails and pushing to image server
    apt-get -q -y install curl imagemagick

    # for captures only during daylight
    apt-get -q -y install libdatetime-event-sunrise-perl

    # for the ffmpeg version
    echo "deb http://www.deb-multimedia.org wheezy main non-free" >> /etc/apt/sources.list
    apt-get update
    apt-get -q -y install deb-multimedia-keyring
    apt-get -q -y install ffmpeg

    # info cgi needs json
    apt-get -q -y install libjson-perl

    # include mqtt compatibility
    cd /home/origo/dist
    wget http://dev.origo.lan/fs/dist/mqtt/Net-MQTT-Simple-1.21.tar.gz
    cd /home/origo/build
    tar xvfz ../dist/Net-MQTT-Simple-1.21.tar.gz
    cd Net-MQTT-Simple-1.21
    perl Makefile.PL
    make
    make test
    make install
}

install_eyesee() {
    uid=1004
    gid=1004

    # link to this source
    curdir=$(pwd)
    ln -s $curdir /opt

    # create the user
    groupadd --gid $gid eyesee
    useradd --uid $uid --gid $gid eyesee

    # create the configuration
    mkdir -p /etc/eyesee

    # create the logging area
    mkdir -p /var/log/eyesee
    cp etc/logrotate.d/eyesee /etc/logrotate.d
    cp etc/cron.d/eyesee /etc/cron.d
}

# images are saved to /var/eyesee/img/<id>/
# videos are saved to /var/eyesee/vid/<id>/
# temporary caching in /var/eyesee/cache/
config_eyesee_collector() {
    # usage: install.sh datadir addr

    datadir=$1
    if [ "$datadir" = "" ]; then
        datadir=/var/www/html
    fi
    addr=$2
    if [ "$addr" = "" ]; then
        addr=192.168.8.20
    fi

    # create the destination for images and videos
    mkdir -p ${datadir}/img
    ln -s ${addr} ${datadir}/img/cam
    ln -s ${addr} ${datadir}/img/cam0
    mkdir -p ${datadir}/vid
    ln -s ${addr} ${datadir}/vid/cam
    ln -s ${addr} ${datadir}/vid/cam0
    chown -R eyesee ${datadir}/img
    chown -R eyesee ${datadir}/img

    # directory for caching thumbnail images
    mkdir -p /var/lib/eyesee
    chown -R eyesee /var/lib/eyesee
}

# images are received to /var/eyesee/img/<id>/
config_eyesee_server() {
    # usage: install.sh datadir

    datadir=$1

    # install the cgi script
    ln -s /opt/eyesee/cgi-bin/rcvimg ${cgidir}

    # let web server write to image and video directories
    chmod 775 ${datadir}/img
    chmod 775 ${datadir}/vid
    chgrp www-data ${datadir}/img
    chgrp www-data ${datadir}/vid

    # let web server owner write to log directory
    chown www-data /var/log/eyesee
}

install_prereq
install_eyesee
config_eyesee_collector
