#!/usr/bin/perl
# move image files into subdirectories

use File::Find;
use POSIX;
use strict;

# format for date/time in the log messages
my $DATE_FORMAT = "%Y.%m.%d %H:%M:%S";

my $srcdir = '/tmp';
my $dstdir = '/tmp';
my $doit = 1;            # set to 0 for debug
my $verbose = 1;

while($ARGV[0]) {
    my $arg = shift;
    if ($arg eq '--srcdir') {
        $srcdir = shift;
    } elsif ($arg eq '--dstdir') {
        $dstdir = shift;
    } elsif ($arg eq '--debug') {
        $doit = 0;
    } elsif ($arg eq '--verbose') {
        $verbose = 1;
    }
}

logmsg("scanning $srcdir");
my @files;
find ( sub {
    return unless -f;
    my $fn = $File::Find::name;
    return unless $fn =~ /\d.avi$/ || $fn =~ /\d.mp4$/;
    push @files, $File::Find::name;
       }, $srcdir);

my $cnt = scalar @files;
logmsg("found $cnt files");
foreach my $f (@files) {
    my($fn) = $f =~ /([^\/]+)$/;
    my($subdir) = $fn =~ /^(\d\d\d\d\d\d\d\d)/;
    if($subdir ne "") {
        if(! -d $dstdir/$subdir) {
            docmd("mkdir $dstdir/$subdir");
        }
        docmd("mv $f $dstdir/$subdir/$fn");
    }
}

exit 0;



sub docmd() {
    my($cmd) = @_;
    logmsg($cmd);
    my $rc = -1;
    my $s = -1;
    my $fail = 0;
    if ($doit) {
        system($cmd);
        if ($? == -1) {
            $fail = 1;
            logmsg("failed to execute: $!");
        } elsif ($? & 127) {
            $s = ($? & 127);
            my $dump = ($? & 128) ? " (with coredump)" : q();
            logmsg("child died with signal $s$dump");
        } else {
            $rc = $? >> 8;
            if ($rc != 0) {
                logmsg("child exited with value $rc");
            }
        }
    }
    return ($fail, $rc, $s);
}

sub logmsg {
    my ($msg) = @_;
    my $tstr = strftime $DATE_FORMAT, localtime time;
    print "$tstr $msg\n" if $verbose;
}
