#!/usr/bin/python -u
__version__ = '0.1.0'
'''Data archiver for output from Brultech monitoring devices.

Move records from one table to an archive table in the same database.

Changelog:

- 0.1.0 25oct12 mwall
* initial implementation
'''
__author__ = 'mwall'


# database defaults
DB_HOST          = 'localhost'
DB_USER          = 'ecmuser'
DB_PASSWD        = 'ecmpass'
DB_DATABASE      = 'ecm'
DB_FILENAME      = 'ecm.db'   # filename for sqlite databases
DB_TABLE         = 'ecm1240bin_counters'

# standard tables include:
#   gem48ptbin_counters
#   ecm1240bin_counters
#   ecm1220bin_counters

import optparse
import sys
import time
import traceback

try:
    import ConfigParser
except Exception, e:
    ConfigParser = None

# logging and error reporting
LOG_ERROR = 0
LOG_WARN  = 1
LOG_INFO  = 2
LOG_DEBUG = 3
LOGLEVEL  = 2

def dbgmsg(msg):
    if LOGLEVEL >= LOG_DEBUG:
        logmsg(msg)

def infmsg(msg):
    if LOGLEVEL >= LOG_INFO:
        logmsg(msg)

def wrnmsg(msg):
    if LOGLEVEL >= LOG_WARN:
        logmsg(msg)

def errmsg(msg):
    if LOGLEVEL >= LOG_ERROR:
        logmsg(msg)

def logmsg(msg):
    ts = fmttime(time.localtime())
    print "%s %s" % (ts, msg)

def fmttime(seconds):
    return time.strftime("%Y/%m/%d %H:%M:%S", seconds)

def getgmtime():
    return int(time.time())


class DB(object):
    def __init__(self, table):
        self.table = table
        self.arctable = '%s_arc' % table

class MySQLDB(DB):
    def __init__(self, host, user, passwd, database, table):
        self.host = host
        self.user = user
        self.passwd = passwd
        self.database = database
        table = '%s.%s' % (database, table)
        super(MySQLDB, self).__init__(table)

class SqliteDB(DB):
    def __init__(self, filename, table):
        self.filename = filename
        super(SqliteDB, self).__init__(table)


class Archiver(object):
    def __init__(self, db):
        self.db = db

    def run(self):
        pass


if __name__ == '__main__':
    parser = optparse.OptionParser(version=__version__)

    parser.add_option('-q', '--quiet', action='store_true', dest='quiet', default=False, help='quiet output')
    parser.add_option('-v', '--verbose', action='store_false', dest='quiet', default=False, help='verbose output')
    parser.add_option('--debug', action='store_true', default=False, help='debug output')

    group = optparse.OptionGroup(parser, 'mysql options')
    group.add_option('--mysql', action='store_true', dest='mysql_out', default=False, help='write data to mysql database')
    group.add_option('--mysql-host', help='database host', metavar='HOSTNAME')
    group.add_option('--mysql-user', help='database user', metavar='USERNAME')
    group.add_option('--mysql-passwd', help='database password', metavar='PASSWORD')
    group.add_option('--mysql-database', help='database name', metavar='DATABASE')
    group.add_option('--mysql-table', help='database table', metavar='TABLE')
    parser.add_option_group(group)

    group = optparse.OptionGroup(parser, 'sqlite options')
    group.add_option('--sqlite', action='store_true', dest='sqlite_out', default=False, help='write data to sqlite database')
    group.add_option('--sqlite-file', help='database filename', metavar='FILE')
    group.add_option('--sqlite-table', help='database table', metavar='TABLE')
    parser.add_option_group(group)

    (options, args) = parser.parse_args()

    if options.quiet:
        LOGLEVEL = LOG_ERROR
    if options.debug:
        LOGLEVEL = LOG_DEBUG

    if options.mysql_out:
        db = MySQLDB(options.mysql_host or DB_HOST,
                     options.mysql_user or DB_USER,
                     options.mysql_passwd or DB_PASSWD,
                     options.mysql_database or DB_DATABASE,
                     options.mysql_table or DB_TABLE)
    elif options.sqlite_out:
        db = SqliteDB(options.sqlite_file or DB_FILENAME,
                      options.sqlite_table or DB_TABLE)
    else:
        print 'Please specify a database type:'
        print '  --mysql'
        print '  --sqlite'
        sys.exit(1)

    arc = Archiver(db)
    arc.run()

    sys.exit(0)
